;Woot 2022 - ZXmasCarol
;UGLISTEP SEQUENCER     
;plays godrestyemerrygentlemen

	    org    32768 
           
			exx
            push	hl				; store this for clean return to basic
            di       
			ld		hl,smccol1+1
            ld		(hl),16+5
            ld		hl,smccol2+1
			ld		(hl),2

			call	cls
			ld		hl,progmess
            exx
			ld		hl,longnote
            call	playsong
            call	printlyric
            exx
            
 			ld		hl,smccol1+1
            ld		(hl),17
            ld		hl,smccol2+1
			ld		(hl),6
            
			ld 		b,11
			
noiseloop:	push	bc
			call	rand_8
            and 	%00000111
            inc		a
            ld		h,a
            ld		l,100
            call    playnote ;load data (hl)  l=length, h=pitch 
			pop		bc
            djnz	noiseloop
            ld		a,7
			out  	(254),a
            
            ei
            ld		b,36
pause:      halt
      		djnz	pause     
                    

            di

			ld		hl,smccol1+1
            ld		(hl),16+5
            ld		hl,smccol2+1
			ld		(hl),2

            ld		hl,longnote
            call	playsong

 			ld		hl,smccol1+1
            ld		(hl),17
            ld		hl,smccol2+1
			ld		(hl),6

            jr 		songstart


rand_8:				; 8 bit random number generator. Just used for bleeps
	LD	A,(r_seed)	; get seed
	AND	0xB8			; mask non feedback bits
	SCF				; set carry
	JP	po,no_clr	; skip clear if odd
	CCF				; complement carry (clear it)
no_clr:
	LD	A,(r_seed)	; get seed back
	RLA				; rotate carry into byte
	LD	(r_seed),A	; save back for next prn
	RET				; done
r_seed:
	defb	43		; prng seed byte (must not be zero)

songstart:
			ld		hl,smccol1+1
            ld		(hl),17
            ld		hl,smccol2+1
			ld		(hl),6
songagain:
			ld		hl,lyric
            exx
nextverse:
			ld      hl,songminus     ;setup the song fragment 

			call    playverse  
            ld		a,13
            rst		16
			ld      hl,song         ;setup the song fragment 

			call	playverse 
            call 	0dafh			;cls
			ld      hl,song         ;setup the song fragment 
			call    playverse
			ld		a,13
            rst		16
            ld      hl,song         ;setup the song fragment 

			call	playverse

      		ld a,1               		; lower screen
      	    call 5633            		; open channel
  		    ld de,finalmess      		; address of string
            ld bc,eostring-finalmess-1  ; length of string to print
            call 8252           		; print the string
            
            exx
            pop hl
            exx
            ei
            ld hl,23560         ; LAST K system variable.
       		ld (hl),0           ; put null value there.
waitloop:
		    ld a,(hl)           ; new value of LAST K.
            cp 0                ; is it still zero?
            jr z,waitloop           ; yes, so no key pressed.
            ret                 ; key was pressed       


playverse:
			call 	printlyric
			call    playsong            ;and play it
            call 	printlyric
			call    testloop            ;and play it
            call 	printlyric
			call    testloop            ;and play it
            call 	printlyric
			call    testloop            ;and play it
            call 	printlyric
			call    testloop            ;and play it
            call 	printlyric
			call    testloop            ;and play it            
            call 	printlyric
			call    testloop            ;and play it            
            call 	printlyric
			call    testloop            ;and play it            
            call 	printlyric
			call    testloop            ;and play it
            ret

cls:
			call 0dafh
            ld   a,13
            rst	 16
            ret
printlyric:
			exx
            call printlyricline
            ld	a,13
            rst 16
            exx
            ret
printlyricline:
			ld	a,(hl)
            inc hl
            or  a
            ret z
            rst 16
            jr  printlyricline
;
 
playsong:   ;called with HL pointing at the musidata 
            ld      (songpointer),hl ;prime the songpointer with the song fragment 
testloop: 
            ld      hl,(songpointer) 
            ld      (smc_data+1),hl 
            inc     hl 
            inc     hl 
            ld      (songpointer),hl 
smc_data: 
            ld      hl,(auld1) 
            ld      a,l           ;check if L (low byte) is zero (end of song marker), if so, return 
            or      a 
            ret     z 
 
;Check for a 'rest' (is the value of H=0) 
            ld      a,h 
            or      a 
            jr      z,rest_routine 
 
            call    playnote 
 
   ;         jr      rest_routine  ;THIS IS INSERTING GAPS EACH TIME, FOR TESTING PURPOSES 
 
            jr      testloop         ; Loop to next element in song 
 
; 
rest_routine: 
            ld      bc,20000         ;insterts an audible gap THIS NEEDS TO BE BASED UPON length of L, ****but isn't, yet*** 
insert_pause: 
            ld		a,7 
            out		(254),a
            nop 
            dec     bc 
            ld      a,b 
            or      c 
            jr      nz,insert_pause 
            jr      testloop       ; Loop to next element in song 
 
 
 
playnote: 
;load data (hl)  l=length, h=pitch 
tempo_smc: 
            ld      a,2                             ;eg. 4 - wow many times through the loop (sort of tempo multipler) 
            ld      (smc_length+1),a                ;setup the length of loop where it's reset 
            ld      (noteroll),a ;noteroll          ;and initially 
 
            ld      (notelength),hl 
 
            ld      e,1                             ;make sure there is no errant "previous note" that matches the one playing 
 
jumpbackpoint:                          ;come back here to setup d with the pitch of the note 
 
            ld      hl,noteroll         ;noteroll is a X-to-0 counter that determines how many times 
            dec     (hl)                ;it goes through the cycle (i.e. the length in the l register) 
            jr      nz,skipcounterdown  ; 
smc_length: 
            ld      (hl),0              ;reset noteroll to it's value (equates to tempo) (will have been setup previously) 
 
 
            ld      hl,notelength       ;notelength is length (see also noteroll, though) 
            dec     (hl)                ;decrease it until it's zero 
            ret     z                   ; 
 
 
skipcounterdown: 
 
            ld      hl,notepitch        ;d is given the required pitch 
            ld      d,(hl) 
 
 
 
 
generateanote:   ;generate a note 
                 ;pitch is held in register d 
                 ;but first check is it a "new" note ? 
            ld      a,d 
            cp      e                   ;e holds previous note 
            jr      z,sameoldnote       ;if it is the same, then we don't need to change counters etc 
newnotebeingplayed: 
            xor     a                   ;clear carry flag) 
            ld      a,d 
            ld      e,a                 ;store that note for comparisson next time 
            ld      (smc_ug2+1),a 
            rra                         ;a=d/2 
            ld      c,a                 ;c is used to keep counter temporarily 
 
sameoldnote:                            ;enter here if if is the same note as before 
            ld      a,c                 ;restore counter 
 
 
            inc     a                   ;inc counter 
            ld      b,a                 ;load it into b, for a djnz loop 
killsometime: 
            nop                          ;4 tstates,one byte 
            cp      (hl)                 ;7 tstates, one byte, no purpose - just killing some time 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates 
            nop                          ;4 tstates 
 
            ;cp      (ix+1)               ;19 T states in THREE BYTES 
 
 
            djnz    killsometime 
 
          ;  ld      a,17                 ;will determine border colour as well.  16+colour.  17=blue 
smccol1:    ld      a,16+1  
			out     (254),a 
 
            ld      a,d                  ;get the pitch 
            sub     c                    ;take away the counter 
            inc     a                    ;add 1 to stop it ever being zero 
            ld      b,a                  ;put the result into b 
 
killsometime2: 
            nop                          ;4 tstates,one byte 
            cp      (hl)                 ;7 tstates, one byte, no purpose - just killing some time 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates 
            nop                          ;4 tstates    TOTAL = 36 T-states in 5 bytes 
 
            ;cp      (ix+1)               ;19 T states in THREE BYTES 
            ;                             ;+ 
            ;cp      (hl)                 ;7 T-states 
            ;cp      (hl)                 ;+7 T-states 
            ;nop                          ;+4=18 T states in THREE BYTES 
                                          ; 
                                          ; TOTAL = 37 T-states in SIX BYTES 
 
 
 
            djnz    killsometime2 
 
smccol2:    ld      a,6                  ;also determine border colour.  0+colour .  6=yellow 
            out     (254),a 
 
                                         ;now we'll change the pulse width by changing a/c 
            ld      a,c 
 
smc_ug1:                                 ;this is smc modified to change whether pulse width is increasing or decreasing 
            add     a,255                ;either add or subtract 1  (subtract 1=adding 255) 
            ld      c,a                  ;update c 
 
            jp      z,changedirection 
smc_ug2:             
            ld      a,0                  ;this is smc modified when a new note is played 
            cp      c 
            jp      z,changedirection 
            jp      jumpbackpoint 
 
changedirection:     
            ld      a,(smc_ug1+1)         ;uses twos complement to turn 1 into 255 and vice versa 
            cpl                           ; 
            inc     a                     ; 
            ld      (smc_ug1+1),a         ; 
            jp      jumpbackpoint 
 
 
 
; these variables are set up used to count the note length, and wavelength 
noteroll:   db      0 
notelength: db      1 
notepitch:  db      253 ; note length and pitch 
songpointer: dw     auld1 
 
 
 
;SONGDATA (Auld Lang Syne) 
longnote:
			db 255,e3
			db 0,0

auld1:                  ;should auld aquaintance be forgot, 
song:
;god rest ye merry
             db e3c/2,e3 ; GOD
songminus:					; after first note
			db e3c/2,e3
             db b3c/2,b3
             db b3c/2,b3
             db a3c/2,a3
             db g3c/2,g3
             db fs3c/2,fs3
             db e3c/2,e3
             db 0,0
         
             db d3c/2,d3
             db e3c/2,e3             
			 db fs3c/2,fs3
             db g3c/2,g3
             db a3c/2,a3
             db b3c/2*3,b3
             db 0,0
;god rest ye merry
             db e3c/2,e3
             db e3c/2,e3
             db b3c/2,b3
             db b3c/2,b3
             db a3c/2,a3
             db g3c/2,g3
             db fs3c/2,fs3
             db e3c/2,e3
             db 0,0
         
             db d3c/2,d3
             db e3c/2,e3             
			 db fs3c/2,fs3
             db g3c/2,g3
             db a3c/2,a3
             db b3c/2*3,b3
             db 0,0
;to save us              
             db b3c/2,b3
             db c4c/2,c4   
             db a3c/2,a3
             db b3c/2,b3
			 db c4c/2,c4
             db d4c/2,d4
             db e4c/2,e4
             db b3c/2,b3
			 db a3c/2,a3
 			 db 0,0
 
             db g3c/2,g3
             db e3c/2,e3             
			 db fs3c/2,fs3
             db g3c/2,g3
             db a3c,a3
 			 db 0,0
;oh tidings 
 
             db g3c/2,g3
             db a3c/2,a3
             db b3c,b3  
             db c4c/2,c4
			 db b3c/2,b3  
             db b3c/2,b3  
             db a3c/2,a3  
             db g3c/2,g3
             db fs3c/2,fs3
             db e3c,e3
             db 0,0
;comfort and joy
             db g3c/4,g3
             db fs3c/4,fs3
             db e3c/2,e3            
             db a3c,a3  
 			 db 0,0
;oh ho tidings             
             db g3c/2,g3
             db a3c/2,a3
             db b3c/2,b3  
             db c4c/2,c4
			 db d4c/2,d4  
             db e4c/2,e4  
             db b3c/2,b3
             db a3c/2,a3  
             db g3c/2,g3
             db fs3c/2,fs3
             db e3c*2,e3
             db 250,0
             db 250,0
           ;  db 250,0
             db 250,0             
             
             defb 0,0
lyric:             
	;defb "God rest ye, merry Gentlemen",0
	defb "God bless the ZX Spectrum",0

	defb "And play it ev'ry day",0

	;defb "Let nothing you dismay",0
	;defb "Let nothing you dismay",0
	;defb "Ferranti's ULA",0

	;defb "For Jesus Christ our Saviour",0
	defb "From Uncle Clive our saviour",0
	
    ;defb "Was born upon this Day.",0
    defb "Ferranti's ULA",0

    ;defb "To us on Chrsitmas Day",0
	
    ;defb "To save poor souls from Satan's power,",0
	defb "Rubber keys and power brick",0
    ;defb "To SAVE our souls from Amstrad's power,",0
	
    ;defb "Which long time had gone astray.",0
	;defb "He'd never give away,",0
   	defb "and one Z80A",0
	
    ;defb "Which long time had gone astray.",0
	defb "Oh hiding such comfort and joy",0
    defb "(More than a toy)",0
    defb "Oh-o hiding such comfort and joy",0
           

	;defb "God rest ye, merry Gentlemen",0
	defb "Obsess on ZX Spectrums",0

	defb "And pray they LOAD okay",0

	;defb "For Jesus Christ our Saviour",0
	defb "Cos not-quite-right behaviour",0
	
    ;defb "Was born upon this Day.",0
    defb "Might cause an R-Tape day",0
	
    ;defb "To save poor souls from Satan's power,",0
	defb "At least you don't use Micro-",13,"Drives",0
   	defb "And tapes survive don't they?",0
	defb "Oh hiding such comfort and joy",0
    defb "(More than a toy)",0
    defb "Oh-o hiding such comfort and joy",0
 
 
	;defb "God rest ye, merry Gentlemen",0
	defb "Caress your ZX Spectrum",0
	defb "And swear the Sinclair way",0
	;defb "For Jesus Christ our Saviour",0
	defb "Is yours & yours forever more",0
    ;defb "Was born upon this Day.",0
    defb "So never lured away",0
	
    ;defb "To save poor souls from Satan's power,",0
	defb "Commodore's C64s",0
   	defb "And Amstrads hold no sway",0
	defb "Deciding that you're a Spectrum boy",0
    defb "(Girl or a boy)",0
    defb "Oh deciding that you are a",13,"Spectrum boy",0
    
    
    defb "Confess the ZX Spectrum",0
    defb "Is all you play today",0
    defb "While PS5s and Xboxes",0,"Are sadly packed away",0
    defb "And Quickshot IIs are things youUse",0 
    defb "When firing up Match Day",0
    defb "Supplying such comfort and joy",0
    defb "(More than a toy)",0
    defb "40 years of pure unbridled joy",0
finalmess:    
	defb 22,1,0,18,1,"ZX Spectrum: The best! 1982-2022",0
eostring:
progmess:	
			defb "PROGRAM: ZXmasCarol",0
            db 0,0

 
 
 

 
 
;Define notes' 
c3              equ      253    ;c# [concert tunings, 440hz] 
cs3             equ      240    ;d 
db3             equ      240    ;d 
d3              equ      226    ;d# 
ds3             equ      212    ;e 
eb3             equ      212    ;e 
e3              equ      200    ;f 
f3              equ      188    ;f# 
fs3             equ      177    ;g 
gb3             equ      177    ;g 
g3              equ      166    ;g# 
gs3             equ      156    ;a 
ab3             equ      156    ;a 
a3              equ      147    ;a# 
as3             equ      137    ;b 
bb3             equ      137    ;b 
b3              equ      129    ;C 
c4              equ      122    ;C# 
cs4             equ      114    ;D 
db4             equ      114    ;D 
d4              equ      108    ;D# 
ds4             equ      101    ;E 
eb4             equ      101    ;E 
e4              equ      95     ;F 
f4              equ      88     ;F# 
fs4             equ      83     ;G 
gb4             equ      83     ;G 
g4              equ      77     ;G# 
gs4             equ      73     ;A 
ab4             equ      73     ;A 
a4              equ      68    ;A# 
as4             equ      63    ;B 
bb4             equ      63    ;B 
        
;define note lengths (of crotchets) 
c3c             equ      60    ;c# 
cs3c            equ      63    ;d 
db3c            equ      63    ;d 
d3c             equ      67    ;d# 
ds3c            equ      72    ;e 
eb3c            equ      72    ;e 
e3c             equ      76    ;f 
f3c             equ      80    ;f# 
fs3c            equ      85    ;g 
gb3c            equ      85    ;g 
g3c             equ      90    ;g# 
gs3c            equ      96    ;a 
ab3c            equ      96    ;a 
a3c             equ      101    ;a# 
as3c            equ      108    ;b 
bb3c            equ      108    ;b 
b3c             equ      114    ;C 
c4c             equ      120    ;C# 
cs4c            equ      128    ;D 
db4c            equ      128    ;D 
d4c             equ      135    ;D# 
ds4c            equ      143    ;E 
eb4c            equ      143    ;E 
e4c             equ      151    ;F 
f4c             equ      162    ;F# 
fs4c            equ      171    ;G 
gb4c            equ      171    ;G 
g4c             equ      183    ;G# 
gs4c            equ      192    ;A 
ab4c            equ      192    ;A 
a4c             equ      204    ;A# 
as4c            equ      218    ;B 
bb4c            equ      218    ;B 
 
d3q          	equ 34 
e3q          	equ 38 
f3q          	equ 40 
g3q          	equ 45 
a3q          	equ 51 




            	end     32768